//
//  SCMessageCenter.h
//  SweetCocoaAppKit
//
//  Created by Rico on 5/13/13.
//
//

#import <Foundation/Foundation.h>

#import "SCMessage.h"
#import "SCMessageAlert.h"
#import "SCMessageListSerializer.h"
#import "SCMessageCondition.h"
#import "SCMessageBadge.h"
#import "SCBadgeImageView.h"

FOUNDATION_EXPORT NSString * const kSCMessageCenterMessagesKey;

FOUNDATION_EXPORT NSString * const kSCMessageCenterCurrentDateKey;
FOUNDATION_EXPORT NSString * const kSCMessageCenterNumDaysOfUseKey;

FOUNDATION_EXPORT NSString * const kSCMessageCenterLastCheckedKey;
FOUNDATION_EXPORT NSString * const kSCMessageCenterETagKey;

enum SCMessageAction : NSInteger {
    SCMessageDefaultAction   = 0,
    SCMessageAlternateAction = 1
};

typedef NSInteger SCMessageAction;

@interface SCMessageCenter : NSObject <NSURLConnectionDelegate>

@property (strong) NSString* messagesUrl;

@property (strong) NSArray *dueMessages;

@property BOOL debugMode;
@property BOOL showPreviewMessages;

- (SCMessageCenter*)initWithMessagesUrl:(NSString*)messagesUrl;

- (SCMessageAlert*)alertForMessage:(SCMessage*)message;

// For testing only
- (void)loadLocalMessages;

- (void)asyncLoadMessages;

- (void)didShowMessage:(SCMessage*)message action:(SCMessageAction)userAction;

- (void)debugReset;

- (void)bindDueMessageCountToObject:(id)object propertyName:(NSString*)propertyName;

- (void)showNextDueMessageAsAlertInWindow:(NSWindow*)window;

@end
